//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
// Security\SecurityClasses.cs
using System;
using System.Security;
using System.Security.Permissions;
using System.Runtime.InteropServices;

class NativeMethods
{
    // Wywoanie do niezarzdzanego kodu. Wykonanie tej metody wymaga
    // uprawnienia zabezpiecze UnmanagedCode. Prba wywoania tej metody
    // bez takiego uprawnienia spowoduje zgoszenie wyjatku SecurityException:
    [DllImport("user32.dll")]
    public static extern int MessageBox(uint hWnd, string lpText, 
       string lpCaption, uint uType);
}

class MainClass
{
    private static void CallUnmanagedCodeWithoutPermission()
    {
        // Utworzenie obiektu uprawnie zabezpiecze w celu opisania
		// uprawnienia UnmanagedCode:
        SecurityPermission perm = 
           new SecurityPermission(SecurityPermissionFlag.UnmanagedCode);

        // Usunicie UnmanagedCode z aktualnego zestawu uprawnie:
        perm.Deny();

        try
        {
            Console.WriteLine("Prba wywoania niezarzdzanego kodu bez uprawnienia.");
            NativeMethods.MessageBox(0, "Witaj wiecie!", "", 0);
            Console.WriteLine("Wywoano niezarzdzany kod bez uprawnienia. Bd!");
        }
        catch (SecurityException)
        {
            Console.WriteLine("Przechwycono wyjtek zabezpiecze w czasie prby wywoania niezarzdzanego kodu.");
        }
    }

    private static void CallUnmanagedCodeWithPermission()
    {
        // Utworzenie obiektu uprawnie zabezpiecze w celu opisania
		// uprawnienia UnmanagedCode:
        SecurityPermission perm = 
           new SecurityPermission(SecurityPermissionFlag.UnmanagedCode);

        // Dodanie UnmanagedCode do aktualnego zestawu uprawnie:
        perm.Assert();

        try
        {
            Console.WriteLine("Prba wywoania niezarzdzanego kodu z uprawnieniem.");
            NativeMethods.MessageBox(0, "Witaj wiecie!", "", 0);
            Console.WriteLine("Wywoano niezarzdzany kod z uprawnieniem.");
        }
        catch (SecurityException)
        {
            Console.WriteLine("Przechwycono wyjtek zabezpiecze w czasie prby wywoania niezarzdzanego kodu.");
        }
    }

    public static void Main() 
    {
        CallUnmanagedCodeWithoutPermission();
        CallUnmanagedCodeWithPermission();
    }
}
